using System;
using System.Data;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;
using System.Collections;
//Using the broken rules of the ProlongedTransfusionReport because they are the same as
//the rules for the CostAccountingReport
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.ProlongedTransfusionReport;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.BOL
{
	/// <summary>
	/// Summary description for CostAccountingReport.
	/// </summary>
	public class CostAccountingReport : VbecsReport
	{
        Hashtable _dataSource = new Hashtable();

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2665"> 
		///		<ExpectedInput>start date, end date</ExpectedInput>
		///		<ExpectedOutput>CostAccountingReport object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2667"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="startDate"></param>
		/// <param name="endDate"></param>
		public CostAccountingReport(DateTime startDate, DateTime endDate)
		{
			this.StartDate = startDate;
			this.EndDate = endDate;
		}

		///<Developers>
		///	<Developer>Rob Heiberger</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/6/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6127"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="6128"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Blank Constructor
		/// </summary>
		public CostAccountingReport()
		{
			SetInitialBrokenRules( BROKEN.FormClassName, BROKEN.RuleSets.BaseRuleSet );

		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/24/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5440"> 
		///		<ExpectedInput>Common.CostAccountingReportSections.IncomingShipment</ExpectedInput>
		///		<ExpectedOutput>DataTable containig IncomingShipment data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5441"> 
		///		<ExpectedInput>Common.CostAccountingReportSections.OutgoingShipment</ExpectedInput>
		///		<ExpectedOutput>DataTable containig OutgoingShipment data</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="0" testid ="5442"> 
		///		<ExpectedInput>Common.CostAccountingReportSections.UnitModification</ExpectedInput>
		///		<ExpectedOutput>DataTable containing UnitModification data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5443"> 
		///		<ExpectedInput>Common.CostAccountingReportSections.OffSiteABID</ExpectedInput>
		///		<ExpectedOutput>DataTable containing OffSiteABID data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5444"> 
		///		<ExpectedInput>Common.CostAccountingReportSections.DiscardedUnit</ExpectedInput>
		///		<ExpectedOutput>DataTable containing DisardedUnit data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5445"> 
		///		<ExpectedInput>Common.CostAccountingReportSections.Main</ExpectedInput>
		///		<ExpectedOutput>DataTable containing data for the main report</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5446"> 
		///		<ExpectedInput>Common.CostAccountingReportSections.Unknown</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Generate data source for Cost Accounting Report
		/// </summary>
		/// <param name="reportSection"></param>
		/// <returns></returns>
		public DataTable GetCostAccountingReport(Common.CostAccountingReportSections reportSection)
		{
			DataTable dtCostAccounting = null;

			switch(reportSection)
			{
				case Common.CostAccountingReportSections.IncomingShipment:
					dtCostAccounting = DAL.Shipment.GetIncomingShipments(this.StartDate, this.EndDate);
					dtCostAccounting.Columns.Add(ARTIFICIAL.ABORh);

					//converting ShipmentGuid column of type Guid to ShipmentGuid column of type string - used to group records on report
					//grouping does not work on Guid type columns
					dtCostAccounting.Columns[TABLE.Shipment.ShipmentGuid].ColumnName = ARTIFICIAL.Guid;
                    dtCostAccounting.PrimaryKey = new DataColumn[0];
					dtCostAccounting.Columns.Add(TABLE.Shipment.ShipmentGuid);
					foreach(DataRow drIncomingShipment in dtCostAccounting.Rows)
					{
						drIncomingShipment[ARTIFICIAL.ABORh] = drIncomingShipment[TABLE.BloodUnitMedia.BloodTypeCode].ToString().Trim();
						drIncomingShipment[ARTIFICIAL.ABORh] += " ";
						drIncomingShipment[ARTIFICIAL.ABORh] += drIncomingShipment[TABLE.RhFactor.RhFactorText].ToString().Trim();

						if (drIncomingShipment.IsNull(TABLE.BloodUnitFinance.UnitCost))
						{
							drIncomingShipment[TABLE.BloodUnitFinance.UnitCost] = 0;
						}

						if (drIncomingShipment.IsNull(TABLE.BloodUnitFinance.SpecialTestingCost))
						{
							drIncomingShipment[TABLE.BloodUnitFinance.SpecialTestingCost] = 0;
						}
						drIncomingShipment[TABLE.Shipment.ShipmentGuid] = drIncomingShipment[ARTIFICIAL.Guid].ToString();
					}
					dtCostAccounting.Columns.Remove(ARTIFICIAL.Guid);
					break;
				case Common.CostAccountingReportSections.OutgoingShipment:
					dtCostAccounting = DAL.Shipment.GetOutgoingShipments(this.StartDate, this.EndDate);
					//converting ShipmentGuid column of type Guid to ShipmentGuid column of type string - used to group records on report
					//grouping does not work on Guid type columns
					dtCostAccounting.Columns[TABLE.Shipment.ShipmentGuid].ColumnName = ARTIFICIAL.Guid;
					dtCostAccounting.PrimaryKey = new DataColumn[0];
                    dtCostAccounting.Columns.Add(TABLE.Shipment.ShipmentGuid);
					foreach(DataRow drOutgoingShipment in dtCostAccounting.Rows)
					{
						drOutgoingShipment[TABLE.Shipment.ShipmentGuid] = drOutgoingShipment[ARTIFICIAL.Guid].ToString();
						if (drOutgoingShipment.IsNull(TABLE.BloodUnitFinance.ReturnCreditAmount))
						{
							drOutgoingShipment[TABLE.BloodUnitFinance.ReturnCreditAmount] = 0;
						}
					}
					dtCostAccounting.Columns.Remove(ARTIFICIAL.Guid);
					break;
				case Common.CostAccountingReportSections.Modifications:
					dtCostAccounting = DAL.BloodUnitModification.GetUnitModifications(this.StartDate, this.EndDate);
					break;
				case Common.CostAccountingReportSections.OffSiteABID:
					dtCostAccounting = DAL.SpecimenTest.GetOffSiteAntibodyIDs(this.StartDate, this.EndDate);
					break;
				case Common.CostAccountingReportSections.DiscardedUnits:

					dtCostAccounting = DAL.BloodUnit.GetDiscardedUnits(this.StartDate, this.EndDate);
					dtCostAccounting.Columns.Add(ARTIFICIAL.DiscardType);
					foreach(DataRow drDiscardedUnit in dtCostAccounting.Rows)
					{
						if (drDiscardedUnit.IsNull(TABLE.BloodUnitFinance.ReturnCreditAmount))
						{
							drDiscardedUnit[ARTIFICIAL.DiscardType] = "Waste";
						}
						else
						{
							drDiscardedUnit[ARTIFICIAL.DiscardType] = "Credit";
						}
					}

					break;
				case Common.CostAccountingReportSections.InactivatedUnits:
					dtCostAccounting = DAL.BloodUnit.GetInactivatedUnitsList(this.StartDate, this.EndDate);
					break;
				case Common.CostAccountingReportSections.Main:
					dtCostAccounting = new DataTable();
					dtCostAccounting.Columns.Add(ARTIFICIAL.IncomingShipmentsVisibleIndicator, typeof(bool));
					dtCostAccounting.Columns.Add(ARTIFICIAL.OutgoingShipmentsVisibleIndicator, typeof(bool));
					dtCostAccounting.Columns.Add(ARTIFICIAL.UnitModificationsVisibleIndicator, typeof(bool));
					dtCostAccounting.Columns.Add(ARTIFICIAL.OffSiteABIDsVisibleIndicator, typeof(bool));
					dtCostAccounting.Columns.Add(ARTIFICIAL.DiscardedUnitsVisibleIndicator, typeof(bool));
					dtCostAccounting.Columns.Add(ARTIFICIAL.InactivatedUnitsVisibleIndicator, typeof(bool));

					DataSet dsCostAccounting = new DataSet();
					dsCostAccounting.Tables.Add(dtCostAccounting);
					break;
				default:
					dtCostAccounting = new DataTable();
					break;
			}

			return dtCostAccounting;
		}

        
		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/8/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7438"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7439"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Generate and print report
		/// Used by VbecsConsoleReport application
		/// </summary>
        protected override VbecsReportPrinter createReportPrinter()
		{

            BOL.VbecsUser user = new BOL.VbecsUser(this.PrintedBy);
            DataTable dtIncomingShipments = this.GetCostAccountingReport(Common.CostAccountingReportSections.IncomingShipment);
            DataTable dtOutgoingShipments = this.GetCostAccountingReport(Common.CostAccountingReportSections.OutgoingShipment);
            DataTable dtUnitModifications = this.GetCostAccountingReport(Common.CostAccountingReportSections.Modifications);
            DataTable dtOffSiteABIDs = this.GetCostAccountingReport(Common.CostAccountingReportSections.OffSiteABID);
            DataTable dtDicardedUnits = this.GetCostAccountingReport(Common.CostAccountingReportSections.DiscardedUnits);
            DataTable dtInactivatedUnits = this.GetCostAccountingReport(Common.CostAccountingReportSections.InactivatedUnits);
            
            DataTable dtMainReport = this.GetCostAccountingReport(Common.CostAccountingReportSections.Main);
            DataRow drMainReport = dtMainReport.NewRow();

            if (dtIncomingShipments.Rows.Count == 0)
                drMainReport["IncomingShipmentsVisibleIndicator"] = false;
            else
            {
                drMainReport["IncomingShipmentsVisibleIndicator"] = true;
                _dataSource.Add(Common.CostAccountingReportSections.IncomingShipment, dtIncomingShipments);
            }

            if (dtOutgoingShipments.Rows.Count == 0)
                drMainReport["OutgoingShipmentsVisibleIndicator"] = false;
            else
            {
                drMainReport["OutgoingShipmentsVisibleIndicator"] = true;
                _dataSource.Add(Common.CostAccountingReportSections.OutgoingShipment, dtOutgoingShipments);
            }

            if (dtUnitModifications.Rows.Count == 0)
            {
                drMainReport["UnitModificationsVisibleIndicator"] = false;
            }
            else
            {
                drMainReport["UnitModificationsVisibleIndicator"] = true;
                _dataSource.Add(Common.CostAccountingReportSections.Modifications, dtUnitModifications);
            }

            if (dtOffSiteABIDs.Rows.Count == 0)
                drMainReport["OffSiteABIDsVisibleIndicator"] = false;
            else
            {
                drMainReport["OffSiteABIDsVisibleIndicator"] = true;
                _dataSource.Add(Common.CostAccountingReportSections.OffSiteABID, dtOffSiteABIDs);
            }

            if (dtDicardedUnits.Rows.Count == 0)
                drMainReport["DiscardedUnitsVisibleIndicator"] = false;
            else
            {
                drMainReport["DiscardedUnitsVisibleIndicator"] = true;
                _dataSource.Add(Common.CostAccountingReportSections.DiscardedUnits, dtDicardedUnits);
            }

            if (dtInactivatedUnits.Rows.Count == 0)
                drMainReport["InactivatedUnitsVisibleIndicator"] = false;
            else
            {
                drMainReport["InactivatedUnitsVisibleIndicator"] = true;
                _dataSource.Add(Common.CostAccountingReportSections.InactivatedUnits, dtInactivatedUnits);
            }

            dtMainReport.Rows.Add(drMainReport);

            _dataSource.Add(Common.CostAccountingReportSections.Main, dtMainReport);


            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(user.UserName);

            string reportCriteria = "Date Range: ";
            reportCriteria += Common.VBECSDateTime.FormatDateString(this.StartDate);
            reportCriteria += " - ";
            reportCriteria += Common.VBECSDateTime.FormatDateString(this.EndDate);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(reportCriteria);

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (_dataSource[Common.CostAccountingReportSections.Main] != null)
            {
                reportSourceMain.Name = "CostAccountingMainDataSet";
                reportSourceMain.Value = (DataTable)_dataSource[Common.CostAccountingReportSections.Main];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + "\\Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CostAccountingReport.CostAccountingReport.rdlc");
            Stream streamIncomingShipment = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CostAccountingReport.IncomingShipment.rdlc");
            Stream streamOutgoingShipment = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CostAccountingReport.OutgoingShipment.rdlc");
            Stream streamUnitModifications = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CostAccountingReport.UnitModifications.rdlc");
            Stream streamOffSiteABIDs = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CostAccountingReport.OffSiteABIDs.rdlc");
            Stream streamDiscardedUnits = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CostAccountingReport.DiscardedUnits.rdlc");
            Stream streamInactivatedUnits = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CostAccountingReport.InactivatedUnits.rdlc");

            LocalReport report = new LocalReport();
            report.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);

            report.DataSources.Add(reportSourceMain);
            report.DataSources.Add(reportSourceHeader);
            report.DataSources.Add(reportSourceFooter);
            report.LoadReportDefinition(stream);
            report.LoadSubreportDefinition("IncomingShipment", streamIncomingShipment);
            report.LoadSubreportDefinition("OutgoingShipment", streamOutgoingShipment);
            report.LoadSubreportDefinition("UnitModifications", streamUnitModifications);
            report.LoadSubreportDefinition("OffSiteABIDs", streamOffSiteABIDs);
            report.LoadSubreportDefinition("DiscardedUnits", streamDiscardedUnits);
            report.LoadSubreportDefinition("InactivatedUnits", streamInactivatedUnits);

            return new BOL.VbecsReportPrinter(this.PrinterName, true, report);
        }

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "IncomingShipment" || e.DataSourceNames[0].ToString() == "IncomingShipmentDataSet")
            {
                ReportDataSource reportSourceIncomingShipment = new ReportDataSource();
                if (_dataSource[Common.CostAccountingReportSections.IncomingShipment] != null)
                {
                    reportSourceIncomingShipment.Name = "IncomingShipmentDataSet";
                    reportSourceIncomingShipment.Value = (DataTable)_dataSource[Common.CostAccountingReportSections.IncomingShipment];
                }
                e.DataSources.Add(reportSourceIncomingShipment);
            }
            else if (e.ReportPath == "OutgoingShipment" || e.DataSourceNames[0].ToString() == "OutgoingShipmentDataSet")
            {
                ReportDataSource reportSourceOutgoingShipment = new ReportDataSource();
                if (_dataSource[Common.CostAccountingReportSections.OutgoingShipment] != null)
                {
                    reportSourceOutgoingShipment.Name = "OutgoingShipmentDataSet";
                    reportSourceOutgoingShipment.Value = (DataTable)_dataSource[Common.CostAccountingReportSections.OutgoingShipment];
                }
                e.DataSources.Add(reportSourceOutgoingShipment);
            }
            else if (e.ReportPath == "UnitModifications" || e.DataSourceNames[0].ToString() == "UnitModificationsDataSet")
            {
                ReportDataSource reportSourceUnitModifications = new ReportDataSource();
                if (_dataSource[Common.CostAccountingReportSections.Modifications] != null)
                {
                    reportSourceUnitModifications.Name = "UnitModificationsDataSet";
                    reportSourceUnitModifications.Value = (DataTable)_dataSource[Common.CostAccountingReportSections.Modifications];
                }
                e.DataSources.Add(reportSourceUnitModifications);
            }
            else if (e.ReportPath == "OffSiteABIDs" || e.DataSourceNames[0].ToString() == "OffSiteABIDsDataSet")
            {
                ReportDataSource reportSourceOffSiteABIDs = new ReportDataSource();
                if (_dataSource[Common.CostAccountingReportSections.OffSiteABID] != null)
                {
                    reportSourceOffSiteABIDs.Name = "OffSiteABIDsDataSet";
                    reportSourceOffSiteABIDs.Value = (DataTable)_dataSource[Common.CostAccountingReportSections.OffSiteABID];
                }
                e.DataSources.Add(reportSourceOffSiteABIDs);
            }
            else if (e.ReportPath == "DiscardedUnits" || e.DataSourceNames[0].ToString() == "DiscardedUnitsDataSet")
            {
                ReportDataSource reportSourceDiscardedUnits = new ReportDataSource();
                if (_dataSource[Common.CostAccountingReportSections.DiscardedUnits] != null)
                {
                    reportSourceDiscardedUnits.Name = "DiscardedUnitsDataSet";
                    reportSourceDiscardedUnits.Value = (DataTable)_dataSource[Common.CostAccountingReportSections.DiscardedUnits];
                }
                e.DataSources.Add(reportSourceDiscardedUnits);
            }
            else if (e.ReportPath == "InactivatedUnits" || e.DataSourceNames[0].ToString() == "InactivatedUnitsDataSet")
            {
                ReportDataSource reportSourceInactivatedUnits = new ReportDataSource();
                if (_dataSource[Common.CostAccountingReportSections.InactivatedUnits] != null)
                {
                    reportSourceInactivatedUnits.Name = "InactivatedUnitsDataSet";
                    reportSourceInactivatedUnits.Value = (DataTable)_dataSource[Common.CostAccountingReportSections.InactivatedUnits];
                }
                e.DataSources.Add(reportSourceInactivatedUnits);
            }
        }

	}
}
